package com.nexgo.apiv3demo;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;

import com.nexgo.common.ByteUtils;
import com.nexgo.oaf.apiv3.SystemServiceHelper;
import com.nexgo.oaf.apiv3.Utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;


public class KioskHelper {


    private static KioskHelper sInstance = null;
    private static Logger mLogger = LoggerFactory.getLogger("KoiskHelper");



    /**************系统接口CMD定义 system service define command**************/
    private final static int CMD_BASE = getCMDBASE();
    public final static int CMD_SLEEP_OR_WAKEUP = CMD_BASE + 200430 + 1;  //休眠和唤醒
    public final static int CMD_Shutdown = CMD_BASE + 201225 + 1;         //关机命令
    public final static int CMD_GetDataNetworkID = CMD_BASE + 210226 + 1; //获取当前使用数据流程卡ID
    public final static int CMD_START_LOCK = (CMD_BASE + 221116) * 10 + 1;//设置应用霸屏
    private final static int CMD_STOP_LOCK = (CMD_BASE + 221116) * 10 + 2;//取消应用霸屏
    public final static int CMD_SET_DEVICEOWNER = (CMD_BASE + 210817) * 10 + 1;// 设置DeviceOwner
    /**
     * 设置霸屏应用列表 格式"com.jamie.myapplication,com.jamie.myapplication1,com.xgd.epm"
     */
    private final static int CMD_SET_SPAPPLIST = (CMD_BASE + 221201) * 10 + 1;
    /**
     * 开机自启霸屏应用 1.自启动 0.不自启动
     */
    private final static int CMD_AUTOBOOT_SPAPP = (CMD_BASE + 221201) * 10 + 2;
    /**
     * 设置开机自启动列表
     */
    private final static int CMD_AUTOBOOT_SPAPP_LIST = (CMD_BASE + 221211) * 10 + 1; //设置开机自启列表
    /**
     * 判断当前是否霸屏状态，并返回包名
     */
    private final static int CMD_IS_SPAPP_RUNNING = (CMD_BASE + 221222) * 10 + 1; // 判断当前是否处于霸屏状态
    /**
     * 获取所有应用流量信息
     */
    public final static int CMD_GET_TRAFFIC = (getCMDBASE() + 231013) * 10 + 1; // 获取设备流量信息
    public final static int CMD_SCREEN_TIMEOUT = (getCMDBASE() + 231105) * 10 + 1; //设置屏幕休眠时间

    private static int getCMDBASE() {
        final String model = Utils.getProperty("ro.product.model", "");
        final String xgdmodel = Utils.getProperty("ro.xgd.type", model);
        mLogger.debug("current model:{}", xgdmodel);

        if ("N5s".equalsIgnoreCase(xgdmodel) || "N6".equals(xgdmodel)) {
            return 30000000;
        } else if ("N5".equals(xgdmodel)) {
            return 10000000;
        } else if ("N86".equals(xgdmodel)) {
            return 50000000;
        } else if ("N3".equals(xgdmodel)) {
            return 20000000;
        } else if ("F900".equals(xgdmodel)) {
            return 40000000;
        } else if ("N5PRO".equals(xgdmodel)) {
            return 60000000;
        } else if ("N82".equals(xgdmodel)) {
            return 80000000;
        } else if ("UN20".equals(xgdmodel)) {
            return 70000000;
        }
        return 0;
    }

    public static KioskHelper getInstance() {
        synchronized (KioskHelper.class) {
            if (sInstance == null) {
                sInstance = new KioskHelper();
            }
        }
        return sInstance;
    }



    public void init(Context context) {
        SystemServiceHelper.getInstance().init(context);
    }
    /**
     * 设置应用霸屏列表，如果为空，
     *
     * @param strKiosk 霸屏列表字符串
     */
    public int setKioskAppList(String strKiosk) {
        mLogger.debug("霸屏应用列表:{}", strKiosk);
        byte[] inParam;
        if (TextUtils.isEmpty(strKiosk)) {
            inParam = new byte[0];
        } else {
            inParam = strKiosk.getBytes(StandardCharsets.UTF_8);
        }
        byte[] outParam = new byte[10];
        byte[] otherParam = new byte[10];
        try {
            int ret = SystemServiceHelper.getInstance().getICloudService().generalMethod(CMD_SET_SPAPPLIST, inParam, outParam, otherParam);
            mLogger.debug("设置霸屏列表返回:{}", ret);
            return ret;
        } catch (RemoteException e) {
            mLogger.error("设置霸屏异常", e);
            return -1;
        }
    }

    public void setKioskAutoStartList(String strAutoStart) {
        mLogger.debug("自启动应用列表:{}", strAutoStart);
        byte[] inParam;
        if (TextUtils.isEmpty(strAutoStart)) {
            inParam = new byte[0];
        } else {
            inParam = strAutoStart.getBytes(StandardCharsets.UTF_8);
        }
        byte[] outParam = new byte[10];
        byte[] otherParam = new byte[10];
        try {
            int ret = SystemServiceHelper.getInstance().getICloudService().generalMethod(CMD_AUTOBOOT_SPAPP_LIST, inParam, outParam, otherParam);
            mLogger.debug("设置应用自启动列表返回:{}", ret);
        } catch (RemoteException e) {
            mLogger.error("设置应用自启动列表异常", e);
        }

        //先设置自启动列表，再打开自启动开关
        if (TextUtils.isEmpty(strAutoStart)) {
            setKioskAutoStart(false);
        } else {
            setKioskAutoStart(true);
        }
    }

    private void setKioskAutoStart(boolean isAutoStart) {
        mLogger.debug("是否打开自启动功能:{}", isAutoStart);
        try {
            byte[] inParam;
            if (isAutoStart) {
                inParam = new byte[]{1};
            } else {
                inParam = new byte[]{0};
            }
            byte[] outParam = new byte[10];
            byte[] otherParam = new byte[10];
            int ret = SystemServiceHelper.getInstance().getICloudService().generalMethod(CMD_AUTOBOOT_SPAPP, inParam, outParam, otherParam);
            mLogger.debug("设置应用自启动返回:{}", ret);
        } catch (RemoteException e) {
            mLogger.error("设置应用自启动异常", e);
        }
    }

    public void exitKioskMode() {
        byte[] inParam = new byte[0];
        byte[] outParam = new byte[10];
        byte[] otherParam = new byte[10];
        try {
            int ret = SystemServiceHelper.getInstance().getICloudService().generalMethod(CMD_STOP_LOCK, inParam, outParam, otherParam);
            mLogger.debug("退出霸屏返回:{}", ret);
        } catch (RemoteException e) {
            mLogger.error("EXIT KIOSK指令执行异常", e);
        }
    }

    public String getKioskPkg() {
        String pkg = "";
        byte[] inParam = new byte[0];
        byte[] outParam = new byte[256];
        byte[] otherParam = new byte[128];
        try {
            int ret = SystemServiceHelper.getInstance().getICloudService().generalMethod(CMD_IS_SPAPP_RUNNING, inParam, outParam, otherParam);
            mLogger.debug("判断当前是否霸屏模式返回:{}", ret);
            if (ret == 0) {
                mLogger.debug("返回的数据：{}", ByteUtils.byteArray2HexString(Arrays.copyOf(outParam, 64)));
                pkg = new String(outParam).trim();
                mLogger.debug("获取的包名：{}", pkg);
                if (("null").equalsIgnoreCase(pkg)) {
                    return "";
                } else {
                    return pkg;
                }
            }
        } catch (RemoteException e) {
            mLogger.error("判断当前是否霸屏模式异常", e);
        }
        return pkg;
    }
}
